unit frmSellMyPhone;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ExtCtrls, StdCtrls, PhoneClass;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Panel1: TPanel;
    sgrPhones: TStringGrid;
    cbxBrand: TComboBox;
    edtModel: TEdit;
    edtOwner: TEdit;
    edtPrice: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    btnSave: TButton;
    edtDate: TEdit;
    Label6: TLabel;
    procedure btnSaveClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

var
  phone: TPhone;
  row: Integer = 1;
{$R *.dfm}

procedure TForm1.btnSaveClick(Sender: TObject);
  var
    Brand, Model, Owner: String;
    PurchaseDate: tDateTime;
    Price: Double;

  begin
    // inputs
    Brand := cbxBrand.Items[cbxBrand.ItemIndex];
    Model := edtModel.Text;
    Owner := edtOwner.Text;
    PurchaseDate := StrToDate(edtDate.Text);
    Price := StrToFloat(edtPrice.Text);
    // instantiate the phone
    phone := TPhone.Create(Brand, Model, Owner, PurchaseDate, Price);
    // call the object methods and
    // insert the informaiton in the stringGrid
    sgrPhones.Cells[0, row] := Brand + ' ' + Model;
    sgrPhones.Cells[1, row] := Format('%d years', [phone.calculateAge]);
    sgrPhones.Cells[2, row] := Format('%m', [phone.getPrice]);
    row := row + 1;
  end;

// given code
procedure TForm1.FormShow(Sender: TObject);
  begin
    sgrPhones.Cells[0, 0] := 'Cell Phone';
    sgrPhones.Cells[1, 0] := 'Age';
    sgrPhones.Cells[2, 0] := 'Price';
  end;

end.
